//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.IO;
using System.Xml;
using System.Xml.Serialization;
using System.Text;

public class DateClass
{
    public DateTime d;
	public String s;

	public DateClass()
	{
	}
    public DateClass (String s, DateTime d)
	{
		this.s = s;
		this.d = d;
    }

    public static void Main(String [] args)
	{
		DateTime d = DateTime.Now;
		DateClass corg = new DateClass("To jest test", d);
		DateClass cnew = null;
		string filename = "dateclass.xml";
		
		// Serializacja oryginalnego obiektu klasy
		try
		{
			XmlSerializer ser = new XmlSerializer(typeof(DateClass));
			TextWriter writer = new StreamWriter(filename);
			ser.Serialize(writer, corg);
			writer.Close();
		} 
		catch (Exception e)
		{
			Console.WriteLine(e);
			return;
		}
	
		// Deserializacja do nowego obiektu klasy
		try
		{
			XmlSerializer ser = new XmlSerializer(typeof(DateClass));
			TextReader reader = new StreamReader(filename);
			cnew = (DateClass)ser.Deserialize(reader);
			reader.Close();
		}
		catch (Exception e)
		{
			Console.WriteLine(e);
			return;
		}
	    
		// Wywietlenie w celu sprawdzenia poprawnoci
		Console.WriteLine();
		Console.WriteLine("Wywietlanie oryginalnej klasy...");
		Console.WriteLine(corg);
		Console.WriteLine();
		Console.WriteLine("Wywietlanie nowej klasy...");
		Console.WriteLine(cnew);
		Console.WriteLine();
		Console.WriteLine("Klasy oryginalna i nowa powinny by identyczne!");
		Console.WriteLine();
   }
    
	// Konwersja klasy do bardziej czytelnego formatu. Jest to przydatne w czasie usuwania bdw
    public override string ToString()
	{
		StringBuilder sb = new StringBuilder();
		sb.Append(s + ": ");
		sb.Append(d.ToLongDateString() + " " + d.ToLongTimeString());
		return(sb.ToString());
    }
}



 









